IF OBJECT_ID('p_plug_Farma_tipoRegistro_TrintaECinco') IS NOT NULL
	BEGIN
		DROP PROCEDURE p_plug_Farma_tipoRegistro_TrintaECinco
	END
 
GO 
--exec [p_plug_Farma_tipoRegistro_TrintaECinco] 3, '20251009', 1
--EXEC p_plug_Farma_tipoRegistro_nove 3,'20251009', 1

CREATE PROCEDURE [dbo].[p_plug_Farma_tipoRegistro_TrintaECinco] (@filial int, @data  date, @cd_emp INT= 1)
as
BEGIN
	declare @contador int;
	IF Object_id('tempDB..#TmpResVendas', 'U') IS NOT NULL
		DROP TABLE #TmpResVendas;
	/*********************************************************************************************/
		CREATE TABLE #TmpResVendas (tiporegistro			INT
									, numeroRegistroVenda	INT
									, datareferenciavenda		DATETIME
									, valortotalvendaliquido	MONEY
									, horareferenciavenda	DATETIME
									, numeronota			INT
									, tipopagamento			INT
									, numeroRegistroPessoa	INT
									, tiponotavenda			INT
									, serienota				VARCHAR(50)
									, serieecf				VARCHAR(50)
									, cd_vd					INT
									, uf					VARCHAR(2)
									, cod_cli				INT
									, cd_vend				int
									, delivery varchar(100)
									, ecommerce varchar(100)
									, canalEcommerce varchar(100)
									, detalheCanalEcommerce varchar(100)
									, numeroCaixa varchar(50))

		CREATE TABLE #RetornoPagamentos (
					tipoRegistro varchar(2),
					numeroRegistroVenda INT,
					TipoPagamento VARCHAR(50),
					detalheTipoPagamentosOutros VARCHAR(100),
					ValorReferenciaPagamento money,
					BIN	VARCHAR(20),
					ultimosDigitosCartao VARCHAR(10),
					Bandeira VARCHAR(255),
					detalheBandeiraOutros VARCHAR(255),
					NumeroParcelas INT,
					numeroAutorizacaoNSU VARCHAR(255),
					codigoBanco VARCHAR(255),
					detalheBancoOutros VARCHAR(255)
		)

		INSERT INTO  #TmpResVendas			
		EXEC p_plug_Farma_tipoRegistro_nove	@filial, @data, @cd_emp;
	
		CREATE TABLE #DEPARABANDEIRAS (CODIGOPLUG VARCHAR(10), CODIGOLINX VARCHAR(10))

		INSERT INTO #DEPARABANDEIRAS
		VALUES ('01', '1'),
				('01', '4'),
				('02', '2'),
				('03', '3'),
				('04', '12'),
				('05', '6'),
				('06', '23'),
				('06', '39'),
				('06', '216'),
				('07', '5'),
				('08', '9'),
				('09', '15'),
				('09', '188'),
				('10', '156'),
				('10', '1001'),
				('10', '1002'),
				('10', '1003'),
				('10', '1004'),
				('11','19'),
				('12','50'),
				('13','75'),
				('14','87'),
				('15','11'),
				('16','63'),
				('16','1024'),
				('16','1025'),
				('16','1026'),
				('17','111'),
				('18','8'),
				('20','186'),
				('21','14'),
				('22','124'),
				('23','10'),
				('23','1008'),
				('23','1009'),
				('23','1010'),
				('23','1011'),
				('23','1012'),
				('23','1013'),
				('24','32'),
				('25','35'),
				('26','103'),
				('26','1005'),
				('26','1006'),
				('26','1007'),
				('27','16'),
				('27','144'),
				('27','1014'),
				('27','1015'),
				('27','1016'),
				('27','1017'),
				('27','1018'),
				('27','1019'),
				('27','1020')


		/*Cupons*/

		INSERT INTO #RetornoPagamentos
		SELECT '35' as tipoRegistro,
				numeroRegistroVenda,
				CASE WHEN Pagamento.tipo_pagamento = '03' THEN COALESCE(CARTAO.TIPO_CARTAO,Pagamento.tipo_pagamento) ELSE Pagamento.tipo_pagamento END as TipoPagamento,
				Pagamento.detalheTipo as detalheTipoPagamentosOutros,
				Pagamento.valor_pagamento as ValorReferenciaPagamento,
				'' as BIN,
				'' as ultimosDigitosCartao, /*Não tem*/
				ISNULL(CARTAO.CD_BANDEIRA,'') as Bandeira,
				ISNULL(CARTAO.DS_BANDEIRA,'') as detalheBandeiraOutros,
				ISNULL(CARTAO.PARCELAS,1) as NumeroParcelas,
				ISNULL(CARTAO.CD_AUTORIZACAO,'') as numeroAutorizacaoNSU,
				'' as codigoBanco,
				'' as detalheBancoOutros
		FROM #TmpResVendas V
		INNER JOIN PDV_VD VD ON V.CD_VD = VD.CD_VD
								AND VD.CD_FILIAL = @Filial
								AND VD.CD_EMP = 1
		CROSS APPLY (
						VALUES 
							('01', VD.VLR_DINH, ''),
							('02', VD.VLR_CHQS, ''),
							('03', VD.VLR_CARTAO, ''),
							('07', VD.VLR_CREDIARIO, ''),
							('06', VD.VLR_CONV, ''),
							('99', VD.VLR_DUP, 'Duplicata'),
							('99', VD.VLR_NCC, 'NCC'),
							('99', VD.VLR_TICKETS, 'Tickets')
					) AS Pagamento(tipo_pagamento, valor_pagamento, detalheTipo)
		OUTER APPLY (SELECT TOP 1 CASE 
									WHEN RC.TP_ADM IN (1,3) THEN '04'/*Debito*/
									WHEN RC.TP_ADM IN (0,2) THEN '03'/*Crédito*/
									WHEN RC.TP_ADM IN (7) THEN '09' /*PIX*/
								   ELSE '03' END AS TIPO_CARTAO,
							COALESCE(TEF.NR_AUTORIZACAO, TEF.NSU_SITEF) AS CD_AUTORIZACAO,
							TEF.QTDE_PARCELAS AS PARCELAS,
							ISNULL(DP.CODIGOPLUG,'99') AS CD_BANDEIRA,
							CASE WHEN ISNULL(DP.CODIGOPLUG,'99') = '99' THEN ISNULL(BD.TX_DESCRICAO,'OUTRAS') ELSE '' END AS DS_BANDEIRA
					 FROM PDV_VD_TEF TEF
					 INNER JOIN RC_ADM_CARTAO RC ON RC.CD_ADM_CARTAO = TEF.CD_ADM_CARTAO
					 LEFT JOIN #DEPARABANDEIRAS DP ON DP.CODIGOLINX = RC.CD_BANDEIRA_DTEF
					 LEFT JOIN RC_CONCILIADOR_BANDEIRA BD ON BD.CD_BANDEIRA = RC.CD_BANDEIRA_DTEF
					 WHERE TEF.CD_EMP = VD.CD_EMP
					 AND TEF.CD_FILIAL = VD.CD_FILIAL
					 AND TEF.CD_VD = VD.CD_VD) CARTAO
		WHERE V.TipoNotaVenda = 5
		AND Pagamento.valor_pagamento > 0


		/*Notas Saída*/

		INSERT INTO #RetornoPagamentos
		SELECT '35' as tipoRegistro,
				numeroRegistroVenda,
				'99' as TipoPagamento,
				'Duplicata' as detalheTipoPagamentosOutros,
				SAI.VLR_TOT_PROD as ValorReferenciaPagamento,
				'' as BIN,
				'' as ultimosDigitosCartao,
				'' as Bandeira,
				'' as detalheBandeiraOutros,
				1 as NumeroParcelas,
				'' as numeroAutorizacaoNSU,
				'' as codigoBanco,
				'' as detalheBancoOutros
		FROM #TmpResVendas V
		INNER JOIN EST_NF_SAI SAI ON V.CD_VD = SAI.CD_NF
								AND SAI.CD_FILIAL = @Filial
								AND SAI.CD_EMP = 1
		WHERE V.TipoNotaVenda = 4




		/*Retorno*/

		SELECT tipoRegistro,
					ROW_NUMBER() OVER (
										PARTITION BY r.numeroRegistroVenda
										ORDER BY r.numeroRegistroVenda ASC
									) AS numeroRegistroPagamento,
					numeroRegistroVenda,
					TipoPagamento,
					detalheTipoPagamentosOutros,
					ValorReferenciaPagamento,
					BIN,
					ultimosDigitosCartao,
					Bandeira,
					detalheBandeiraOutros,
					NumeroParcelas,
					numeroAutorizacaoNSU,
					codigoBanco,
					detalheBancoOutros
	   FROM #RetornoPagamentos R
	

END